Enable-PSRemoting -Force -SkipNetworkProfileCheck
#add russian
$OldList = Get-WinUserLanguageList
$OldList.Add("ru-RU")
Set-WinUserLanguageList -LanguageList $OldList -Force
##
Set-WinHomeLocation -GeoId 203
Set-Culture ru-RU

#tuning
Set-ItemProperty -Path HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced -Name TaskbarSmallIcons -Value 1
Stop-Process -Name explorer

Install-PackageProvider -Name nuget -Force -Forcebootstrap -Scope Allusers
Update-Module PackageManagement, PowerShellGet -Force

#run updates and installs in the background
Start-Job { Install-Module PSScriptTools, BurntToast -Force }
#Start-Job { Install-Module PSReleaseTools -Force; Install-PowerShell -Mode Quiet -EnableRemoting -EnableContextMenu }
#Start-Job { Install-Module WTToolbox -Force ; Install-WTRelease }
#Start-Job -FilePath c:\SandBox\scripts\another-script.ps1

#wait for everything to finish
Get-Job | Wait-Job

#sandbox-toast.ps1
$params = @{
    Text    = "Step 1. Modules installed"
    Header  = $(New-BTHeader -Id 1 -Title "My Sandbox")
    Applogo = "c:\SandBox\images\progress.png"
}

New-BurntToastNotification @params

#install winget
Invoke-WebRequest 'https://aka.ms/Microsoft.VCLibs.x64.14.00.Desktop.appx' -OutFile "$env:TEMP\VClibs.appx"
Add-AppxPackage "$env:TEMP\VClibs.appx"

$winget = (Invoke-RestMethod -Uri "https://api.github.com/repos/microsoft/winget-cli/releases/latest").assets.browser_download_url | Where-Object { $_ -match "appxbundle" }
Invoke-WebRequest -Uri $winget -OutFile "$env:TEMP\winget.appxbundle"
Add-AppxPackage "$env:TEMP\winget.appxbundle"
### copy config
$wingetdest = (Get-ChildItem $env:LOCALAPPDATA\Packages | Where-Object { $_.Name -match "DesktopAppInstaller" }).FullName
Copy-Item C:\SandBox\temp\settings.json -Destination $wingetdest\LocalState

#install apps
#sandbox-toast.ps1
$params = @{
    Text    = ""
    Header  = $(New-BTHeader -Id 2 -Title "My Sandbox")
    Applogo = "c:\SandBox\images\progress.png"
}

"Microsoft.Edge", "Microsoft.PowerShell", "Microsoft.WindowsTerminal", "7zip.7zipAlpha" | ForEach-Object {
    winget install $_ --silent --source winget
    $params.Text = "Step 2.x. $_ installed"
    New-BurntToastNotification @params
}

#profile
## for old powershell
#New-Item $PROFILE -Force
#Copy-Item -Path "c:\SandBox\temp\Microsoft.PowerShell_profile.ps1" -Destination $PROFILE
## for powershell core
Copy-Item -Path "c:\SandBox\temp\Microsoft.PowerShell_profile.ps1" -Destination "C:\Program Files\PowerShell\7\profile.ps1"

#sandbox-toast.ps1
$params = @{
    Text    = "Windows Sandbox configuration is complete."
    Header  = $(New-BTHeader -Id 3 -Title "My Sandbox")
    Applogo = "c:\SandBox\images\done.png"
}

New-BurntToastNotification @params